﻿
/*
	INDEX
*/
CREATE UNIQUE INDEX [ME2Category_CategoryName_AK] ON [ME2Category]([CategoryName])
go

create nonclustered index VmInfo_GuestDeviceGuid_IsHost_IX on VmInfo(GuestDeviceGuid,IsHost)
go

/*
	foreign keys
*/

alter table ManagedElementType
	add constraint ManagedElementType_ME2Category_FK foreign key (ME2CategoryID)
			references ME2Category(ME2CategoryID)
go


 alter table OSX_Application
                add constraint OSX_Application_Device_FK foreign key(DeviceGuid)
                    references Device(DeviceGuid)
go

 alter table OSX_DiscBurning
                add constraint OSX_DiscBurning_Device_FK foreign key(DeviceGuid)
                    references Device(DeviceGuid)
go

 alter table OSX_DiskVolume
                add constraint OSX_DiskVolume_Device_FK foreign key(DeviceGuid)
                    references Device(DeviceGuid)
go

 alter table OSX_Display
                add constraint OSX_Display_Device_FK foreign key(DeviceGuid)
                    references Device(DeviceGuid)
go

 alter table OSX_DisplayAdapter
                add constraint OSX_DisplayAdapter_Device_FK foreign key(DeviceGuid)
                    references Device(DeviceGuid)
go

alter table OSX_HardwareOverview
        add constraint OSX_HardwareOverview_Device_FK foreign key(DeviceGuid)
            references Device(DeviceGuid)
go

alter table OSX_MemoryBank
    add constraint OSX_MemoryBank_Device_FK foreign key(DeviceGuid)
        references Device(DeviceGuid)
go

alter table OSX_NetworkInterface
    add constraint OSX_NetworkInterface_Device_FK foreign key(DeviceGuid)
        references Device(DeviceGuid)
go

alter table OSX_OperatingSystem
    add constraint OSX_OperatingSystem_Device_FK foreign key(DeviceGuid)
        references Device(DeviceGuid)
go

alter table OSX_PhysicalDisk
    add constraint OSX_PhysicalDisk_Device_FK foreign key(DeviceGuid)
        references Device(DeviceGuid)
go

alter table VmInfo
    add constraint VmInfo_Device_FK foreign key(DeviceGuid)
        references Device(DeviceGuid)
go

ALTER TABLE [DeviceCoreInfo] ADD CONSTRAINT [DeviceCoreInfo_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [Device]([DeviceGuid])
go










ALTER TABLE [CredentialAttribute]  ADD  CONSTRAINT [CredentialAttribute_CredentialSet_FK] FOREIGN KEY([CredentialSetGuid])
REFERENCES [CredentialSet] ([CredentialSetGuid])
ON DELETE CASCADE
GO

ALTER TABLE [CredentialSet]  ADD  CONSTRAINT [CredentialSet_AuthenticationType_FK] FOREIGN KEY([AuthenticationTypeID])
REFERENCES [AuthenticationType] ([AuthenticationTypeID])
GO


ALTER TABLE [CredentialSet]  ADD  CONSTRAINT [CredentialSet_OwnerType_FK] FOREIGN KEY([OwnerTypeID])
REFERENCES [OwnerType] ([OwnerTypeID])
GO

ALTER TABLE [CredentialSetObjectLink]  ADD  CONSTRAINT [CredentialSetObjectLink_CredentialSet_FK] FOREIGN KEY([CredentialSetGuid])
REFERENCES [CredentialSet] ([CredentialSetGuid])
ON DELETE CASCADE
GO

ALTER TABLE [CredentialSetObjectLink]  ADD  CONSTRAINT [CredentialSetObjectLink_SecurableType_FK] FOREIGN KEY([SecurableTypeID])
REFERENCES [SecurableType] ([SecurableTypeID])
GO

ALTER TABLE [DiscoveryDeviceAfpResponse]  ADD  CONSTRAINT [FK_DiscoveryDeviceAfpResponse_DiscoveryDevice] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDevice] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceDnsData]  ADD  CONSTRAINT [FK_DiscoveryDeviceDnsData_DiscoveryDevice] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDevice] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceNetbiosData]  ADD  CONSTRAINT [FK_DiscoveryDeviceNetbiosData_DiscoveryDevice] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDevice] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDevicePortInfo]  ADD  CONSTRAINT [FK_DiscoveryDevicePortInfo_DiscoveryDevice] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDevice] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceSmbData]  ADD  CONSTRAINT [FK_DiscoveryDeviceSmbData_DiscoveryDevice] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDevice] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceSnmpData]  ADD  CONSTRAINT [FK_DiscoveryDeviceSnmpData_DiscoveryDevice] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDevice] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceSnmpNetworkAdapter]  ADD  CONSTRAINT [FK_DiscoveryDeviceSnmpNetworkAdapter_DiscoveryDeviceSnmpData] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDeviceSnmpData] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceSnmpOid]  ADD  CONSTRAINT [FK_DiscoveryDeviceSnmpOids_DiscoveryDeviceSnmpData] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDeviceSnmpData] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceWmiData]  ADD  CONSTRAINT [FK_DiscoveryDeviceWmiData_DiscoveryDevice] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDevice] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceWmiNetworkAdapter]  ADD  CONSTRAINT [FK_DiscoveryDeviceWmiNetworkAdapter_DiscoveryDeviceWmiData] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDeviceWmiData] ([DeviceGuid])
ON DELETE CASCADE
GO


ALTER TABLE [DiscoveryDeviceZeroConfProperty]  ADD  CONSTRAINT [FK_DiscoveryDeviceZeroConfProperty_DiscoveryDeviceZeroConfResponse] 
	FOREIGN KEY([DeviceGuid], [ServiceName])
		REFERENCES [DiscoveryDeviceZeroConfResponse] ([DeviceGuid], [ServiceName])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceZeroConfResponse]  ADD  CONSTRAINT [FK_DiscoveryDeviceZeroConfResponse_DiscoveryDevice] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDevice] ([DeviceGuid])
ON DELETE CASCADE
GO


ALTER TABLE [DiscoveryIpAddressADComputerEntry]  ADD  CONSTRAINT [FK_DiscoveryIpAddressADComputerEntry_DiscoveryIpAddress] FOREIGN KEY([Address])
REFERENCES [DiscoveryIpAddress] ([Address])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressAfpResponse]  ADD  CONSTRAINT [FK_DiscoveryIpAddressAfpResponse_DiscoveryIpAddress] FOREIGN KEY([Address])
REFERENCES [DiscoveryIpAddress] ( [Address])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressDnsReverseLookupName]  ADD  CONSTRAINT [FK_DiscoveryIpAddressDnsReverseLookupName_DiscoveryIpAddress] FOREIGN KEY([Address])
REFERENCES [DiscoveryIpAddress] ([Address])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressDnsValidatedName]  ADD  CONSTRAINT [FK_DiscoveryIpAddressDnsValidatedName_DiscoveryIpAddress] FOREIGN KEY([Address])
REFERENCES [DiscoveryIpAddress] ([Address])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressPortInfo]  ADD  CONSTRAINT [FK_DiscoveryIpAddressPortInfo_DiscoveryIpAddress] FOREIGN KEY([Address])
REFERENCES [DiscoveryIpAddress] ([Address])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressSmbResponse]  ADD  CONSTRAINT [FK_DiscoveryIpAddressDiscoveryIpAddressSmbResponse] FOREIGN KEY([Address])
REFERENCES [DiscoveryIpAddress] ([Address])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressSnmpResponse]  ADD  CONSTRAINT [FK_DiscoveryIpAddressSnmpResponse_DiscoveryIpAddress] FOREIGN KEY([Address])
REFERENCES [DiscoveryIpAddress] ([Address])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressWmiResponse]  ADD  CONSTRAINT [FK_DiscoveryIpAddressWmiResponse_DiscoveryIpAddress] FOREIGN KEY([Address])
REFERENCES [DiscoveryIpAddress] ([Address])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressZeroConfIp]  ADD  CONSTRAINT [FK_DiscoveryIpAddressZeroConfResponseDiscoveryIpAddressZeroConfIp] FOREIGN KEY([Address], [ServiceName], [HostName])
REFERENCES [DiscoveryIpAddressZeroConfResponse] ([Address], [ServiceName], [HostName])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressZeroConfProperty]  ADD  CONSTRAINT [FK_DiscoveryIpAddressZeroConfResponseDiscoveryIpAddressZeroConfProperty] FOREIGN KEY([Address], [ServiceName], [HostName])
REFERENCES [DiscoveryIpAddressZeroConfResponse] ([Address], [ServiceName], [HostName])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressZeroConfResponse]  ADD  CONSTRAINT [FK_DiscoveryIpAddressDiscoveryIpAddressZeroConfResponse] FOREIGN KEY([Address])
REFERENCES [DiscoveryIpAddress] ([Address])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceADComputerEntry]  ADD  CONSTRAINT [FK_DiscoveryDeviceADComputerEntry_DiscoveryDevice] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDevice] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryIpAddressSshResponse]  ADD  CONSTRAINT [FK_DiscoveryIpAddressSshResponse_DiscoveryIpAddress] FOREIGN KEY([Address])
REFERENCES [DiscoveryIpAddress] ([Address])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceSshData]  ADD  CONSTRAINT [FK_DiscoveryDeviceSshData_DiscoveryDevice] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDevice] ([DeviceGuid])
ON DELETE CASCADE
GO

ALTER TABLE [DiscoveryDeviceSshNetworkAdapter]  ADD  CONSTRAINT [FK_DiscoveryDeviceSshNetworkAdapter_DiscoveryDeviceSshData] FOREIGN KEY([DeviceGuid])
REFERENCES [DiscoveryDeviceSshData] ([DeviceGuid])
ON DELETE CASCADE
GO


/*
	Object:  ForeignKey [FK_DeviceOnboardingIssue_Device]  
*/
ALTER TABLE [DeviceOnboardingIssue]  ADD  CONSTRAINT [FK_DeviceOnboardingIssue_Device] FOREIGN KEY([DeviceGuid])
REFERENCES [Device] ([DeviceGuid])
GO



ALTER TABLE [PluginConfiguration]                 
	ADD  CONSTRAINT [FK_PluginConfiguration_Plugin] 
		FOREIGN KEY([PluginGuid])
			REFERENCES [Plugin] ([PluginGuid])
GO
