﻿/*
	Index

*/
CREATE UNIQUE NONCLUSTERED INDEX [IX_AlertAttributeType] ON [AlertAttributeType] 
(
	[AlertTypeID],
	[AttributeName]
)
GO


/*
	FK

*/
ALTER TABLE [AlertAttributeType]  ADD  CONSTRAINT [FK_AlertAttributeType_AlertType] FOREIGN KEY([AlertTypeID])
REFERENCES [AlertType] ([AlertTypeID])
GO


ALTER TABLE [OpenAlert]  ADD  CONSTRAINT [FK_OpenAlert_AlertRule] FOREIGN KEY([AlertRuleID])
REFERENCES [AlertRule] ([AlertRuleID])
ON UPDATE CASCADE
ON DELETE CASCADE
GO


ALTER TABLE [AlertRuleAttribute]  ADD  CONSTRAINT [FK_AlertRuleAttribute_AlertAttributeType] FOREIGN KEY([AlertAttributeTypeID])
REFERENCES [AlertAttributeType] ([AlertAttributeTypeID])
ON UPDATE CASCADE
ON DELETE CASCADE
GO

ALTER TABLE [AlertRuleAttribute]  ADD  CONSTRAINT [FK_AlertRuleAttribute_AlertRule] FOREIGN KEY([AlertRuleID])
REFERENCES [AlertRule] ([AlertRuleID])
ON UPDATE CASCADE
ON DELETE CASCADE
GO
