﻿CREATE TABLE dbo.Asset_Software(
    [SoftwareAssetGuid]     UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]            UNIQUEIDENTIFIER NOT NULL,
    [Name]                  NVARCHAR (200)   NOT NULL,
    [Version]               NVARCHAR (100)   NULL,
    [Vendor]                NVARCHAR (100)   NULL,
    [InstallDate]           DATETIME         NULL,
    [InstallLocation]       NVARCHAR (256)   NULL,
    [InstallSource]         NVARCHAR (256)   NULL,
    [ProductLanguage]       NVARCHAR (30)    NULL,
    [LocalPackage]          NVARCHAR (150)   NULL,
    [PackageCode]           NVARCHAR (32)    NULL,
    [PackageName]           NVARCHAR (100)   NULL,
    [RegisteredOwner]       NVARCHAR (50)    NULL,
    [ProductID]             NVARCHAR (50)    NULL,
    [RegisteredCompany]     NVARCHAR (50)    NULL,
    [TimesUsed]             NVARCHAR (5)     NULL,
    [LastUsed]              NVARCHAR (22)    NULL,
    [ExecutablePath]        NVARCHAR (130)   NULL,
    [SoftwareID]            NVARCHAR (10)    NULL,
    [ExecutableDescription] NVARCHAR (50)    NULL,
    [ExecutableVersion]     NVARCHAR (50)    NULL,
    [AssignmentType]        NVARCHAR (50)    NULL,
    [InstallState]          NVARCHAR (50)    NULL,
    [DateCreated]           DATETIME         NOT NULL,
    [DateModified]          DATETIME         NOT NULL,
    [OMRowVersion]          rowversion       NOT NULL,
    CONSTRAINT [Asset_Software_Device_FK] FOREIGN KEY              ([DeviceGuid])            REFERENCES dbo.[Device] ([DeviceGuid])
);
go

create CLUSTERED index Asset_Software_DeviceGuid_CLUST_IX on dbo.Asset_Software(DeviceGuid) 
go

create unique nonclustered index Asset_Software_SoftwareAssetGuid_i_DeviceGuid_OMRowVersion_UX 
		on dbo.Asset_Software(SoftwareAssetGuid)  include(DeviceGuid, OMRowVersion)
go



CREATE TABLE [dbo].[Asset_Win32_Service]
(
		 [Win32_ServiceGuid]   UNIQUEIDENTIFIER NOT NULL
		,[DeviceGuid]          UNIQUEIDENTIFIER NOT NULL
        ,[Name]                nvarchar(255)    NOT NULL
        ,[Caption]             nvarchar(255)        NULL
        ,[CheckPoint]          bigint               NULL
        ,[CreationClassName]   nvarchar(50)        NULL
        ,[Description]         nvarchar(2000)        NULL
        ,[DesktopInteract]     bit                  NULL
        ,[DisplayName]         nvarchar(255)        NULL
        ,[ErrorControl]        nvarchar(50)        NULL
        ,[ExitCode]            bigint               NULL
        ,[InstallDate]         datetime             NULL
        ,[PathName]            nvarchar(2000)       NULL
        ,[ProcessId]           bigint               NULL
        ,[ServiceSpecificExitCode]          bigint  NULL
        ,[ServiceType]         nvarchar(50)        NULL
        ,[Started]             bit                  NULL
        ,[StartMode]           nvarchar(50)        NULL
        ,[StartName]           nvarchar(255)        NULL
        ,[State]               nvarchar(50)        NULL 
        ,[Status]              nvarchar(50)        NULL
        ,[SystemCreationClassName]    nvarchar(50) NULL
        ,[SystemName]          nvarchar(50)        NULL
        ,[TagId]               bigint               NULL
        ,[WaitHint]            bigint               null
		,[DateCreated]           DATETIME         NOT NULL
		,[DateModified]          DATETIME         NOT NULL
        ,[OMRowVersion]         rowversion        NOT NULL
        ,CONSTRAINT [Asset_Win32_Service_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid])
);
go

create CLUSTERED index Asset_Win32_Service_DeviceGuid_CLUST_IX on dbo.Asset_Win32_Service(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_Service_Win32_ServiceGuid_i_DeviceGuid_OMRowVersion_UX 
		on dbo.Asset_Win32_Service(Win32_ServiceGuid)  include(DeviceGuid, OMRowVersion)
go

create nonclustered index Asset_Win32_Service_DeviceGuid_Name_IX on dbo.Asset_Win32_Service(DeviceGuid,Name) 
go


CREATE TABLE [dbo].[Asset_Win32_QuickFixEngineering]
(
     [Win32_QuickFixEngineeringGuid]               UNIQUEIDENTIFIER NOT NULL
    ,[DeviceGuid]                 UNIQUEIDENTIFIER NOT NULL
    ,[Caption]                    nvarchar(200)        null      
    ,[CSName]                     nvarchar(100)        null 
    ,[Description]                nvarchar(500)        null 
    ,[FixComments]                nvarchar(200)        null 
    ,[HotFixID]                   nvarchar(260)    not null
    ,[InstallDate]                datetime             null 
    ,[InstalledBy]                nvarchar(100)        null 
    ,[InstalledOn]                nvarchar(100)        null 
    ,[Name]                       nvarchar(200)        null 
    ,[ServicePackInEffect]        nvarchar(100)        null 
    ,[Status]                     nvarchar(100)       null 
    ,[DateCreated]                DATETIME         NOT NULL
    ,[DateModified]               DATETIME         NOT NULL
    ,[OMRowVersion]               rowversion       NOT NULL
    ,CONSTRAINT [Asset_Win32_QuickFixEngineering_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid])
);
go

create CLUSTERED index Asset_Win32_QuickFixEngineering_DeviceGuid_CLUST_IX on dbo.Asset_Win32_QuickFixEngineering(DeviceGuid) 
go

create unique nonclustered index Asset_Win32_QuickFixEngineering_Win32_QuickFixEngineeringGuid_i_DeviceGuid_OMRowVersion_UX 
	on dbo.Asset_Win32_QuickFixEngineering(Win32_QuickFixEngineeringGuid)  include(DeviceGuid, OMRowVersion)
go

create nonclustered index Asset_Win32_QuickFixEngineering_DeviceGuid_HotFixID_IX on dbo.Asset_Win32_QuickFixEngineering(DeviceGuid,HotFixID) 
go



