﻿if exists
(
        select c.name  
        ,ic.* 
        --,i.*
         from sys.index_columns ic 
         join sys.columns       c  on ic.object_id    = c.object_id
                                  and ic.column_id    = c.column_id
         where 
               ic.object_id = object_id('OpenAlert')
           and ic.index_id = 1 -- CLUSTERED
           and c.name = 'Guid'  
           and ic.key_ordinal = 1  -- Guid is the first column in the PK
)
    exec [DBM_Conv_drop_PK] 'OpenAlert'
go

if OBJECT_ID('PK_OpenAlert') is null
    ALTER TABLE [OpenAlert]
    ADD
        CONSTRAINT [PK_OpenAlert] PRIMARY KEY clustered  
        (        
	        [AlertRuleID],
	        [ObjectID],
	        [Guid]
        )
GO 