﻿CREATE TABLE [Asset_IBUAgent] (
  [DeviceGuid] uniqueidentifier NOT NULL
, [UserName] nvarchar(50) NULL
, [ComputerID] nchar(4) NULL
, [AgentVersion] nvarchar(50) NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
ALTER TABLE [Asset_IBUAgent] ADD CONSTRAINT [Asset_IBUAgent_DeviceGuid_PK] PRIMARY KEY ([DeviceGuid]);
GO
ALTER TABLE [CustomLog] DROP CONSTRAINT [FK_CustomLog_Device];
GO
ALTER TABLE [CustomLogMonitor] DROP CONSTRAINT [FK_CustomLogMonitor_CustomLog];
GO
ALTER TABLE [CustomLogData] DROP CONSTRAINT [FK_CustomLogData_CustomLogMonitorSearch];
GO
ALTER TABLE [CustomLogMonitorSearch] DROP CONSTRAINT [FK_CustomLogMonitorSearch_CustomLogMonitor];
GO
ALTER TABLE [CustomLog] ADD [DeviceIDRef] int NULL;
GO 
UPDATE [CustomLog] SET [DeviceIDRef] = [DeviceID]
GO
ALTER TABLE [CustomLog] ALTER COLUMN [DeviceIDRef] int NOT NULL;
GO 
ALTER TABLE [CustomLog] ALTER COLUMN [DeviceID] int NULL;
GO
ALTER TABLE [CustomLog] DROP CONSTRAINT [PK_CustomLog];
GO
ALTER TABLE [CustomLog] ADD CONSTRAINT [PK_CustomLog_DeviceID] PRIMARY KEY ([CustomLogID],[DeviceIDRef]);
GO
ALTER TABLE [CustomLogAlertRule] DROP CONSTRAINT [FK_CustomLogAlertRule_AlertRule];
GO
ALTER TABLE [CustomLogData] ADD [DeviceIDRef] int NULL;
GO
ALTER TABLE [CustomLogData] ALTER COLUMN [DeviceIDRef] int NOT NULL;
GO
ALTER TABLE [CustomLogMonitor] ADD [DeviceIDRef] int NULL;
GO
ALTER TABLE [CustomLogMonitor] DROP CONSTRAINT [PK_CustomLogMonitor];
GO
ALTER TABLE [CustomLogMonitorSearch] ADD [DeviceIDRef] int NULL;
GO
ALTER TABLE [CustomLogMonitorSearch] ALTER COLUMN [DeviceIDRef] int NOT NULL;
GO
ALTER TABLE [CustomLogMonitorSearch] DROP CONSTRAINT [PK_CustomLogMonitorSearch];
GO
ALTER TABLE [CustomLogMonitorSearch] ADD CONSTRAINT [PK_CustomLogMonitorSearch] PRIMARY KEY ([CustomLogMonitorSearchID],[DeviceIDRef]);
GO
ALTER TABLE [CustomLog] ADD CONSTRAINT [FK_CustomLog_Device] FOREIGN KEY ([DeviceID]) REFERENCES [Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [CustomLogMonitor] ADD CONSTRAINT [FK_CustomLogMonitor_CustomLog] FOREIGN KEY ([CustomLogID], [DeviceIDRef]) REFERENCES [CustomLog] ([CustomLogID], [DeviceIDRef]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [CustomLogData] ADD CONSTRAINT [FK_CustomLogData_CustomLogMonitorSearch] FOREIGN KEY ([CustomLogMonitorSearchID], [DeviceIDRef]) REFERENCES [CustomLogMonitorSearch]([CustomLogMonitorSearchID], [DeviceIDRef]) ON DELETE CASCADE ON UPDATE CASCADE;
GO