

-- Add new IBUBackup alert type
SET IDENTITY_INSERT [AlertType] ON
GO

INSERT [AlertType] ([AlertTypeID], [AlertTypeName], [IsSelfHealable], [AllowMultipleAlertRules], [IsLegacy90], [AlertingEngine], [AlertSubjectType], [AlertSourceType]) 
		select 312, N'IbuBackup', 0, 1, 0, 1, 2, 1
		 where not exists (select * from [AlertType] where AlertTypeID = 312)
GO

SET IDENTITY_INSERT [AlertType] OFF
GO


-- Add IBUBackup alert type's attributes
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'Status', 'string', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'Status')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'StartTime', 'DateTime', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'StartTime')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'FinishTime', 'DateTime', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'FinishTime')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'Style', 'string', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'Style')
GO
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'BackupSetName', 'string', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'BackupSetName')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'EventOccurrencesCount', 'int', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'EventOccurrencesCount')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'EventOccurrencesIntervalInMins', 'int', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'EventOccurrencesIntervalInMins')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'FirstEventOccurrence', 'DateTime', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'FirstEventOccurrence')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'LastEventOccurrence', 'DateTime', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'LastEventOccurrence')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'BytesUploaded', 'UInt64', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'BytesUploaded')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'ItemsTransferred', 'uint', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'ItemsTransferred')
GO
INSERT [AlertAttributeType] ([AlertTypeID], [AttributeName], [DataType], [KeyIndex]) 
	select 312, 'BillingUsage', 'string', NULL
		 where not exists (select * from [AlertAttributeType] where AlertTypeID = 312
		                              and [AttributeName] = 'BillingUsage')
GO




